// This header contains necessary structures for setting up correct screen modes,
// pixel formats, audio formats, and so on.

// minify windows.h
#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#define VC_LEANMEAN
#define VC_EXTRALEAN

#include <windows.h>
#include <GL/gl.h>

// global resolution
#define XRES 1920
#define YRES 1080

//#define XRES 1280
//#define YRES 720

// declare this symbol if your code uses floating point types
//extern "C" int _fltused;

#pragma data_seg(".pixelfmt")
static const PIXELFORMATDESCRIPTOR pfd = {
#if BREAK_COMPATIBILITY
	#if POST_PASS
			0, 0, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA,
			0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
	#else
			0, 0, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
	#endif
#else
	sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA,
	32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
#endif
};
 
#pragma data_seg(".screensettings")
static DEVMODE screenSettings = { 
	{0}, 0, 0, sizeof(screenSettings), 0, DM_PELSWIDTH|DM_PELSHEIGHT,
	{0}, 0, 0, 0, 0, 0, {0}, 0, 0, XRES, YRES, 0, 0,
	#if(WINVER >= 0x0400)
		0, 0, 0, 0, 0, 0,
			#if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
			0, 0
		#endif
	#endif
};


// currently unused definitions
#ifdef EDITOR_CONTROLS
	#define FAIL_KILL false
	#define PID_QUALIFIER
#else
	#define FAIL_KILL true
	#define PID_QUALIFIER const
#endif